<?php

  class Pager {

    var $results;
    var $pagesize;
    var $currpage;
    var $row;


    function Pager( $results, $pagesize ) {
      global $page;

      $this->results = $results;
      $this->pagesize = $pagesize;

      if ( (int)$page <= 0 ) { $page = 1; }

      if ( ( $this->getNumPages() > 0 ) && ( $page > $this->getNumPages() ) ) {
        $page = $this->getNumPages(); 
      }

      $this->setPageNum( $page );
    }

    function getNumPages() {
      if ( !$this->results ) return 0;

      return ceil( @mysql_num_rows($this->results) / (float)$this->pagesize );
    } 

    function setPageNum( $pagenum ) {
      if ( ( $pagenum > $this->getNumPages() ) || ( $pagenum <= 0 ) ) return FALSE;

      $this->currpage = $pagenum;
      $this->row = 0;

      @mysql_data_seek( $this->results, ($pagenum-1) * $this->pagesize );
    } 

    function getPageNum() {
      return $this->currpage;
    } 

    function isLastPage() {
      return ($this->currpage >= $this->getNumPages());
    }

    function isFirstPage() {
      return ($this->currpage <= 1);
    }

    function fetchArray() {
      if (!$this->results) return FALSE;
      if ($this->row >= $this->pagesize) return FALSE;
      
      $this->row++;

      return mysql_fetch_array($this->results);
    }

    function getPageNav( $queryvars = '' ) { 
      $nav  = "<table width=100%>\n";
      $nav .= "  <tr>\n";
      $nav .= "    <td width=20% align=right>\n ";

      if ( !$this->isFirstPage() ) {
        $nav .= "      <a href=\"?page=".($this->getPageNum()-1).$queryvars."\">&lt;&lt;</a>\n";
        $dooutput = TRUE;
      } else {
        $nav .= "      &nbsp;\n";
      }

      $nav .= "    </td>\n";
      $nav .= "    <td width=5% align=center nowrap>\n";

      if ( $this->getNumPages() > 1 ) {
        $from = $this->currpage - 7;
        if ( $from < 1 ) $from = 1;
       
        $to = $this->currpage + 7;
        if ( $to > $this->getNumPages() ) $to = $this->getNumPages();

        if ( $from > 1 ) $nav .= "...\n ";
        for ( $i = $from; $i <= $to; $i++) {
          if ($i == $this->currpage) {
            $nav .= "$i\n ";
          } else {
            $nav .= "<a href=\"?page={$i}".$queryvars."\">{$i}</a>\n ";
          }

          $dooutput = TRUE;
        }
        if ( $to < $this->getNumPages() ) $nav .= "...\n ";
      } 

      $nav .= "    </td>\n";
      $nav .= "    <td width=20% align=left>\n";

      if ( !$this->isLastPage() ) {
        $nav .= "       <a href=\"?page=".($this->getPageNum()+1).$queryvars."\">&gt;&gt;</a>\n";
        $dooutput = TRUE;
      } else {
        $nav .= "      &nbsp;\n";
      }

      $nav .= "    </td>\n";
      $nav .= "  </tr>\n";
      $nav .= "</table>\n";

      if ( $dooutput ) {
        return $nav;
      } else {
        return "";      
      }
    }

    function getResultsInfo() {
      if ( $this->results ) {  
        $Count = @mysql_num_rows($this->results);

        $First = ($this->currpage - 1) * $this->pagesize + 1;
        if ( $First < 0 ) $First = 0;
        $Last  = ($this->currpage) * $this->pagesize;
        if ( $Last > $Count ) $Last = $Count;

        $Results = "Results $First - $Last of $Count";

        return $Results;
      }

      return "";
    }

  }

?>