<?php
  Error_Reporting(0);

  // --------------------------------------------------------------------------
  $RequiredPHPVersion     = "4.1.0";
  $RequiredMySQLVersion   = "3.23.0";
  // --------------------------------------------------------------------------

  function GetPHPInfo() {
    ob_start();
    phpinfo(INFO_MODULES);
    $s = ob_get_contents();
    ob_end_clean();
 
    $s = strip_tags($s,'<h2><th><td>');
    $s = preg_replace('/<th[^>]*>([^<]+)<\/th>/',"<info>\\1</info>",$s);
    $s = preg_replace('/<td[^>]*>([^<]+)<\/td>/',"<info>\\1</info>",$s);

    $vTmp = preg_split('/(<h2>[^<]+<\/h2>)/',$s,-1,PREG_SPLIT_DELIM_CAPTURE);
    $vModules = array();

    for ($i=1;$i<count($vTmp);$i++) {
      if (preg_match('/<h2>([^<]+)<\/h2>/',$vTmp[$i],$vMat)) {
        $vName = trim($vMat[1]);
        $vTmp2 = explode("\n",$vTmp[$i+1]);

        foreach ($vTmp2 AS $vOne) {
          $vPat = '<info>([^<]+)<\/info>';
          $vPat3 = "/$vPat\s*$vPat\s*$vPat/";
          $vPat2 = "/$vPat\s*$vPat/";

          if (preg_match($vPat3,$vOne,$vMat)) { 
            $vModules[$vName][trim($vMat[1])] = array(trim($vMat[2]),trim($vMat[3])); 
          } elseif (preg_match($vPat2,$vOne,$vMat)) {
            $vModules[$vName][trim($vMat[1])] = trim($vMat[2]); 
          } 
        } 
      } 
    } 
    
    return $vModules;
  }

  function CheckVersion( $CurrentVersion, $RequiredVersion ) {
    list($majorC, $minorC, $editC) = split('[/.-]', $CurrentVersion);
    list($majorR, $minorR, $editR) = split('[/.-]', $RequiredVersion);
   
    if ($majorC > $majorR) return true;
    if ($majorC < $majorR) return false;

    if ($minorC > $minorR) return true;
    if ($minorC < $minorR) return false;

    if ($editC  >= $editR) return true;
    return true;
  } 

  function CheckDatabase( $DatabaseName ) {
    $db_list = mysql_list_dbs();

    for ($i = 0; $i < mysql_num_rows( $db_list ); $i++) {
      if ( mysql_db_name( $db_list, $i ) == $DatabaseName ) return TRUE;
    }

    return FALSE;
  }

  function CheckTable( $DatabaseName, $TableName ) {
    $tables_list = mysql_list_tables( $DatabaseName );

    for ($i = 0; $i < mysql_num_rows( $tables_list ); $i++) {
      if ( mysql_tablename( $tables_list, $i ) == $TableName ) return TRUE;
    }

    return FALSE;
  }

  function CheckHtaccess() {
    global $RootDir;

    $f = fopen( $RootDir.".htaccess", "r" );
    $Htaccess = fread($f, filesize($RootDir.".htaccess"));
    fclose( $f );

    $Htaccess = str_replace( "\r", "", $Htaccess );
    $Htaccess = str_replace( "\t", "", $Htaccess );
    $Htaccess = str_replace(  " ", "", $Htaccess );

    $HtaccessL = strtolower( $Htaccess );

    $i = strpos( $HtaccessL, 'errordocument403');
    if ( $i === FALSE ) return "";
    $i += 16;
 
    $j = strpos( $HtaccessL, "\n", $i);
    if ( $j === FALSE ) $j = strlen($Htaccess);

    $Err403 = substr( $Htaccess, $i, $j - $i);

    $i = strpos( $HtaccessL, 'errordocument404');
    if ( $i === FALSE ) return "";
    $i += 16;
 
    $j = strpos( $HtaccessL, "\n", $i);
    if ( $j === FALSE ) $j = strlen($Htaccess);

    $Err404 = substr( $Htaccess, $i, $j - $i);

    if ( ($Err403 != $Err404) || ($Err404 == "") ) return "";

    return $Err403;
  }

  function GetDir( $FileName ) {
    $FileName = str_replace( '\\', '/', $FileName );

    $j = -1;
    for ( $i = strlen($FileName); $i >= 0; $i-- ) {
      if ( $FileName[$i] == '/' ) {
        $j = $i;
        break;
      }
    }

    if ( $j >= 0 ) {
      return substr($FileName, 0, $j);
    } else return "";
  }

  function FormatErrorStr( $ErrorStr ) {
    return
      "\n<table align=center border=0 width=95%>\n".
      "  <tr><td><font size=-1>\n".
      "$ErrorStr\n".
      "  </font></td></tr>\n".
      "</table>\n\n";
  }

  function LogProgress( $Message, $IsError = FALSE, $SuccessStr = '', $ErrorStr = '' ) {
    global $ErrorsFound;

    if ( $IsError ) {   
      if ( $ErrorStr == '' ) $ErrorStr = 'Failed';
      echo "$Message ... <font color=#FF0000>$ErrorStr</font><br>\n\n"; 
      $ErrorsFound = TRUE;
    } else {
      if ( $SuccessStr == '' ) $SuccessStr = 'OK'; 
      echo "$Message ... $SuccessStr<br>\n\n"; 
    }
  
    flush;
  }

  function CloseDocument() {
    echo "\n";
    echo "    </td>\n";
    echo "  </tr>\n";
    echo "  <tr>\n";
    echo "    <td id=\"footer\">\n";
    echo "      <p align=\"right\">Powered By DynamicPAD";
    echo "    </td>\n";
    echo "  </tr>\n";
    echo "</table>\n\n";
    echo "</body>\n";
    echo "</html>";
    exit;
  }

  // -- Implementation --------------------------------------------------------
  $RootDir = GetDir( $HTTP_SERVER_VARS["SCRIPT_FILENAME"] )."/";
  $RootURL = GetDir( $HTTP_SERVER_VARS["SCRIPT_URI"] )."/";

  if ( file_exists( $RootDir."phemplate.class.php" ) ) { 
    include( $RootDir."phemplate.class.php" );
  } else {
    die( "<center>PHP Template Engine not found (phemplate.class.php)</center>" );
  }

  if ( file_exists( $RootDir."dp_conf.php.inc" ) ) { 
    include( $RootDir."dp_conf.php.inc" );
  } else {
    die( "<center>DynamicPAD config file not found (dp_conf.php.inc)</center>" );
  }

  $HomeDir = trim( $HomeDir );
  $DataDir = trim( $DataDir );

  $i = strlen( $HomeDir );
  if ( ($i > 0) && ($HomeDir[$i-1] != '/') ) $HomeDir .= '/'; 
  $i = strlen( $DataDir );
  if ( ($j > 0) && ($DataDir[$i-1] != '/') ) $DataDir .= '/'; 

  $tpl = new phemplate();
  $tpl->set_root( $RootDir );
  $tpl->set_file( 'main', 'install.tml', TRUE );
  $tpl->set_unknowns( 'remove_nonjs' );

  $PHPVersion = phpversion();
  if ( !CheckVersion($PHPVersion, $RequiredPHPVersion) ) {
    $tpl->set_var( 'ErrorMessage', "Error: PHP version $RequiredPHPVersion or higher required" );
    $tpl->process( 'ErrorMessagePos', 'ErrorMessageBlock', 0, 0, 1 );
  
    echo $tpl->process( 'out', 'main', 1 );
    CloseDocument();
  }

  $PHPInfo = GetPHPInfo();

  $MySQLVersion = $PHPInfo["mysql"]["Client API version"];
  if ( !CheckVersion($MySQLVersion, $RequiredMySQLVersion) ) {
    $tpl->set_var( 'ErrorMessage', "Error: MySQL version $RequiredMySQLVersion or higher required" );
    $tpl->process( 'ErrorMessagePos', 'ErrorMessageBlock', 0, 0, 1 );

    echo $tpl->process( 'out', 'main', 1 );
    CloseDocument();
  }

  echo $tpl->process( 'out', 'main', 1 );

  $Action = $HTTP_POST_VARS['Action'];

  if ( $Action == 'CreateDB' ) {
    $LogsTableName = $TablesPrefix."report";
    $StatTableName = $TablesPrefix."sitestat";

    $ErrorsFound = FALSE;

    $DBHost = DBHost;
    $DBUser = DBUser;
    $DBPass = DBPass;
    $DBName = DBName;

    $IsError = !mysql_connect( $DBHost, $DBUser, $DBPass );
    LogProgress( "Connecting to the MySQL server", $IsError, "", "Failed<br>\n".FormatErrorStr(mysql_error()) );
                         	
    if ( !$IsError ) {
      if ( CheckDatabase( $DBName ) ) {
        LogProgress( "Creating the database ($DBName)", FALSE, "Already exists" );
      } else {
        $Query = "CREATE DATABASE $DBName";

        $IsError = !mysql_query( $Query ); 
        LogProgress( "Creating the database ($DBName)", $IsError, "", "Failed<br>\n".FormatErrorStr(mysql_error()) );
      }

      if ( !$IsError ) {
        if ( CheckTable( $DBName, $LogsTableName ) ) {
          LogProgress( "Creating the table ($LogsTableName)", FALSE, "Already exists" );
        } else {                                                                  
          $Query = "CREATE TABLE $LogsTableName".
            "(IP text, Referer text, SiteUIN text, ProductUIN text,".
            " Language text, FileType int, RawData text, Date text,".
            " UIN int NOT NULL auto_increment, PRIMARY KEY (UIN))";

          $IsError = !mysql_query( $Query );
          LogProgress( "Creating the table ($LogsTableName)", $IsError, "", "Failed<br>\n".FormatErrorStr(mysql_error()) );
        }

        if ( CheckTable( $DBName, $StatTableName ) ) {
          LogProgress( "Creating the table ($StatTableName)", FALSE, "Already exists" );
        } else {                                                                  
          $Query = "CREATE TABLE $StatTableName".
            "(SiteUIN text, Period text, ProductDownloads int, PADDownloads int)";

          $IsError = !mysql_query( $Query );
          LogProgress( "Creating the table ($StatTableName)", $IsError, "", "Failed<br>\n".FormatErrorStr(mysql_error()) );
        }
      }
    }

    if ( ! $ErrorsFound ) {
      echo "<br>\n\n";

      echo "<b>Installation finished. Now you may delete the ".
           "installation script (install.php). It should be ".
           "deleted for security reasons.</b>";

      echo "<br><br>\n\n";

      echo "<b>Click 'Continue' to proceed to the DynamicPAD Control Panel</b><br>\n";

      echo "<center>\n";
      echo "<form method=POST action='index.php'>\n";
      echo "  <input type=hidden name='Action' value='Login'>\n";
      echo "  <input type=hidden name='Login' value='".Login."'>\n";
      echo "  <input type=hidden name='Password' value='".Password."'>\n";
      echo "  <input type=submit value='Continue' style=\"width: 150\">\n";
      echo "</form>\n";
      echo "</center>\n";
    }

    CloseDocument();
  }

  $ErrorsFound = FALSE;

  $Error404Path = GetDir( $HTTP_SERVER_VARS["PHP_SELF"] )."/dp.php";
  $Error404Conf = CheckHtaccess();

  $IsError = ( $Error404Path != $Error404Conf );
  $ErrorMessage = 
    "Your .htaccess file should contain the ErrorDocument directives that\n".
    "contain a path to the DynamicPAD script (dp.php) relative to your Web\n".
    "server's DocumentRoot folder. Please, add the following lines to your\n".
    ".htaccess file:<br><br>\n".
    "ErrorDocument 404 $Error404Path<br>\n".
    "ErrorDocument 403 $Error404Path<br>";
  $ErrorMessage = "Failed<br>\n".FormatErrorStr($ErrorMessage);
  LogProgress( "Checking the ErrorDocument settings in your .htaccess file", $IsError, "", $ErrorMessage );

  $IsError = ( $HomeDir != $RootDir );
  $ErrorMessage =
    "Your DynamicPAD config file should contain proper file path to the\n".
    "folder where your DynamicPAD scripts are installed. Please, check the\n".
    "foollowing line:<br><br>\n".
    "&nbsp;&nbsp;\$HomeDir = &lt;absolute path to your DynamicPAD folder&gt;<br><br>\n".
    "Example:<br><br>\n".
    "&nbsp;&nbsp;\$HomeDir = $RootDir<br>";
  $ErrorMessage = "Failed<br>\n".FormatErrorStr($ErrorMessage);
  LogProgress( "Checking the DynamicPAD root folder ($HomeDir)", $IsError, "", $ErrorMessage );

  $IsError = !is_dir( $DataDir );
  LogProgress( "Checking the DynamicPAD data folder ($DataDir)", $IsError, "", "Not Found" );

  if ( $ErrorsFound ) {
    echo "<br>\n\n";

    echo "<b>Some issues were found. Please, review the configuration file".
         "(dp_conf.php.inc) and click 'Retry'.</b><br>\n";

    echo "<center>\n";
    echo "<form action='install.php'>\n";
    echo " <input type=submit value='Retry' style=\"width: 150\">\n";
    echo "</form>\n";
    echo "</center>\n";
  } else {
    echo "<br>\n\n";

    echo "<b>Installation script will now create and configure a ".
         "MySQL database. Click 'Continue' to start.</b><br>\n";

    echo "<center>\n";
    echo "<form method=POST action='install.php'>\n";
    echo " <input type=hidden name='Action' value='CreateDB'>\n";
    echo " <input type=submit value='Continue' style=\"width: 150\">\n";
    echo "</form>\n";
    echo "</center>\n";
  }

  CloseDocument();
?>
