<?php
  $AfterLogin = "index.php";

  require_once( $HomeDir."dp_conf.php" );

  $MO = LoadMultiOptions( $ConfigPath );

  if ( $Action == 'UploadProductDatFile' ) {
    $ProductUIN = urldecode( GetGlobalVar( 'ProductUIN' ) );

    if ( (strlen($ProductUIN) == 0) ||
         (strpos($ProductUIN, ".") !== FALSE) || 
         (strpos($ProductUIN, "/") !== FALSE) ||
         (strpos($ProductUIN, "\\") !== FALSE) ) {
      die( "Message=Invalid UIN \"$ProductUIN\"" );
    }     

    $FileName = $DataDir.strtolower($ProductUIN).".dat";
    $ProductName = urldecode( GetGlobalVar('ProgramName') );
    $Data = base64_decode( GetGlobalVar('File') );

    $f = fopen( $FileName, 'w' );
    if ( $f !== FALSE ) {
      fwrite( $f, $Data, strlen($Data) );
      fclose( $f );

      $DAT = LoadMultiOptions( $FileName );

      if ( $DAT['General']['DP_PAD_Template'] != '' ) {
        $MO['Products'][$ProductUIN] = $ProductName;
        SaveMultioptions( $ConfigPath, $MO );
      } else {
        die( "Message=Invalid file format" );
      }
    } else {
      die( "Message=Cannot save \"$FileName\"" );
    }
    die( "Message=OK" );
  }

  require_once( $HomeDir."phemplate.class.php" );

  $tpl = new phemplate();
  $tpl->set_root( $HomeDir );
  $tpl->set_file( 'main', 'index.tml', TRUE );
  $tpl->set_unknowns( 'remove_nonjs' );

  $tpl->set_var( 'Now', date('r') );

  if ( $Action == 'Delete' ) {
    $ProductUIN = GetGlobalVar( 'ProductUIN' );

    if ( (strpos($ProductUIN, ".") === FALSE) && 
         (strpos($ProductUIN, "/") === FALSE) &&
         (strpos($ProductUIN, "\\") === FALSE) ) {
      $FileName = $DataDir.strtolower($ProductUIN).".dat";

      if ( file_exists($FileName) ) unlink($FileName);
    } else {
      $tpl->set_var( 'ErrorMessage', "Error: Invalid UIN $ProductUIN" );
      $tpl->process( 'ErrorMessagePos', 'ErrorMessageBlock', 0, 0, 1 );
    }
  }

  if ( isset($HTTP_POST_FILES['datafile']) ) {
    if (is_uploaded_file($HTTP_POST_FILES['datafile']['tmp_name'])) {
      $TmpName  = $HTTP_POST_FILES['datafile']['tmp_name'];
      $FileName = strtolower($HTTP_POST_FILES['datafile']['name']);

      if ( (strpos($FileName, '.dat') === strlen($FileName) - 4) &&
           (strpos($FileName, '.') === strlen($FileName) - 4) ) {
        $DAT = LoadMultiOptions( $TmpName );

        if ( $DAT['General']['DP_PAD_Template'] != '' ) {
          if ( move_uploaded_file( $TmpName, $DataDir.$FileName ) ) {
            $PAD = $DAT['General']['DP_PAD_Template'];
            $i = strpos( $PAD, "<Program_Name>" );
            $j = strpos( $PAD, "</Program_Name>" );

            if ( ($i !== FALSE) && ($j !== FALSE) ) {       
              $ProductName = substr( $PAD, $i + 14, $j - $i - 14 );
              $ProductName = trim( $ProductName );
            }  

            if ( $ProductName != "" ) {
              $UIN = strtoupper( basename($FileName, '.dat') );    
              $MO['Products'][$UIN] = $ProductName;
              SaveMultioptions( $ConfigPath, $MO );
            }
          } else {
            $tpl->set_var( 'ErrorMessage', "Error: Cannot save \"$FileName\"" );
            $tpl->process( 'ErrorMessagePos', 'ErrorMessageBlock', 0, 0, 1 );
          }
        } else {
          $tpl->set_var( 'ErrorMessage', "Error: Invalid file format" );
          $tpl->process( 'ErrorMessagePos', 'ErrorMessageBlock', 0, 0, 1 );
        }
      } else {
        $tpl->set_var( 'ErrorMessage', "Error: Invalid filename \"$FileName\"" );
        $tpl->process( 'ErrorMessagePos', 'ErrorMessageBlock', 0, 0, 1 );
      } 
    } else {
      $tpl->set_var( 'ErrorMessage', "Error: Connection failed" );
      $tpl->process( 'ErrorMessagePos', 'ErrorMessageBlock', 0, 0, 1 );
    }
  }  

  $RequestURI = GetDir( $HTTP_SERVER_VARS["SCRIPT_NAME"] )."/";

  $DataFiles = array();
  $Dir = opendir( $DataDir );
  while( $File = readdir( $Dir ) ) {
    if ( strpos( $File, '.dat') === strlen($File) - 4 ) {
      $UIN = strtoupper( basename($File, '.dat') );

      $DataFile = array();
      $DataFile['ProductUIN'] = $UIN;
      $DataFile['ProductName'] = $MO['Products'][$UIN];
      $DataFile['DefaultPADURL'] = $RequestURI."info/".strtolower($UIN); 
      
      $DataFiles[] = $DataFile;
    }
  }
  closedir( $Dir );

  $tpl->set_loop( 'AvailableProducts', $DataFiles );

  if ( $Action == 'UpdateSiteList' ) {
    $SiteList = DownloadFile( "www.dynamicpad.org", "/sites/sitelist.php" );

    if ( strlen($SiteList) == 0 ) {
      $tpl->set_var( 'ErrorMessage', "Error: Cannot download site list from DynamicPAD.org" );
      $tpl->process( 'ErrorMessagePos', 'ErrorMessageBlock', 0, 0, 1 );
      echo $tpl->process( 'out', 'main', 1 );
      exit;
    }

    UpdateSection( $MO, "Sites", $SiteList );
    SaveMultioptions( $ConfigPath, $MO );

    $tpl->set_var( 'InfoMessage', "Site list has been successfully updated" );
    $tpl->process( 'InfoMessagePos', 'InfoMessageBlock', 0, 0, 1 );    
    echo $tpl->process( 'out', 'main', 1 );
    exit;
  }

  echo $tpl->process( 'out', 'main', 1 );
?>