<?php
  $AfterLogin = "dp_stat.php";

  require_once( $HomeDir."dp_conf.php" );
  require_once( $HomeDir."phemplate.class.php" );
  require_once( $HomeDir."pager.php" );

  function Dec( $Num, $Len ) {
    $a = $Num;
    while( strlen($a) < $Len ) $a = '0'.$a;
    return $a;
  }

  $tpl = new phemplate();
  $tpl->set_root( $HomeDir );
  $tpl->set_file( 'main', 'dp_stat.tml', TRUE );
  $tpl->set_unknowns( 'remove_nonjs' );

  if ( !mysql_connect( DBHost, DBUser, DBPass ) ) {
    $tpl->set_var( 'ErrorMessage', "Error: Cannot connect to the database" );
    $tpl->process( 'ErrorMessagePos', 'ErrorMessageBlock', 0, 0, 1 );
    echo $tpl->process( 'out', 'main', 1 );
    exit;
  }

  $QueryField = GetGlobalVar( 'QueryField' );
  $Query      = GetGlobalVar( 'Query' );
  $Year       = GetGlobalVar( 'Year' );
  $Month      = GetGlobalVar( 'Month' );

  $Query = strtolower( $Query );
  $Pos = strpos( $Query, '-' );
  if ( $Pos !== FALSE ) {
    $Query = substr( $Query, $Pos + 1 );
  }

  $tpl->set_var( 'Query', $Query ); 
  $tpl->set_var( 'QueryField', $QueryField ); 

  switch($QueryField) {
    case "site":
      $tpl->set_var( 'SiteChecked', "selected" ); 

      $MO = LoadMultiOptions( $ConfigPath );
      $Key = strtoupper( GetKeyByValue( $MO['Sites'], $Query ) );
      if ( strlen($Key) > 0 ) {
        $AddQuery = " AND SiteUIN IN ($Key)";
      } else $AddQuery = " AND SiteUIN LIKE '%$Query%'"; 
      $AddLink = "&QueryField=$QueryField&Query=$Query";

      break;
    case "product":
      $tpl->set_var( 'ProductChecked', "selected" ); 

      $MO = LoadMultiOptions( $ConfigPath );
      $Key = strtoupper( GetKeyByValue( $MO['Products'], $Query ) );
      if ( strlen($Key) > 0 ) {
        $AddQuery = " AND ProductUIN IN ($Key)";
      } else $AddQuery = " AND ProductUIN LIKE '%$Query%'";
      $AddLink = "&QueryField=$QueryField&Query=$Query";

      break;
    default: 
      $AddQuery = ""; 
      $AddLink = "";
      break;
  }

  $Months  = array("January","February","March","April",
    "May","June","July","August","September","October","November","December"); 

  $CurrentDate  = getdate();
  $CurrentYear  = $CurrentDate['year'];
  $CurrentMonth = $CurrentDate['mon'];
  $CurrentDay   = $CurrentDate['mday'];

  $Periods = array(); 
  $TDS = array();

  if ( (strlen($Year) > 0) && (strlen($Month) > 0) ) {
    $TDSPeriod = " WHERE Period='$Year-".Dec( $Month, 2 )."'";
  } else {
    $TDSPeriod = "";
  }

  $r = @mysql( DBName, "SELECT DISTINCT(SiteUIN), ".
    "SUM(PADDownloads), SUM(ProductDownloads) AS 'Prod'".
    "FROM $StatTableName $TDSPeriod GROUP BY SiteUIN ORDER BY Prod DESC" );  

  if ( !$r ) {
    $tpl->set_var( 'ErrorMessage', "Error: ".mysql_error() );
    $tpl->process( 'ErrorMessagePos', 'ErrorMessageBlock', 0, 0, 1 );
    echo $tpl->process( 'out', 'main', 1 );
    exit;
  }

  $Pager = new Pager( $r, $MaxResultsPerPage );
  
  $NavLink = $Pager->getPageNav( "&Year=$Year&Month=$Month" );
  
  $tpl->set_var( 'TDSNavLink', $NavLink );

  $MO = LoadMultiOptions( $ConfigPath );
  $SitesList = $MO['Sites'];

  while( $f = $Pager->fetchArray() ) {
    $TDSItem = array( 
      "Site"                => $f[0],
      "PADDownloads"        => $f[1],
      "ProductDownloads"    => $f[2],
    );

    $SiteName = $SitesList[strtoupper($f[SiteUIN])];
    if ( strlen($SiteName) != 0 ) $TDSItem['Site'] = $SiteName;
 
    $TDS[] = $TDSItem;
  }
  $tpl->set_loop( 'TDS', $TDS );
   
  if ( (strlen($Year) > 0) && (strlen($Month) > 0) ) {
    $FromDay = 1;

    if ( $Month < 1 ) $Month = 1;
    if ( $Month > 12 ) $Month = 12;

    if ( $Year < $StartYear ) $Year = $StartYear;

    if ( $Year == $StartYear ) {
      if ( $Month < $StartMonth )  $Month = $StartMonth;
      if ( $Month == $StartMonth ) $FromDay = $StartDay;
    }

    if ( $Year > $CurrentYear ) {
      $Year = $CurrentYear;

      if ( $Month > $CurrentMonth ) $Month = $CurrentMonth;
    }

    if ( ($Year == $CurrentYear) && ($Month == $CurrentMonth) ) {
      $DaysCount = $CurrentDay;
    } else {
      $Time = mktime( 0, 0, 0, $Month, 0, $Year );
      $DaysCount = Date("t", $Time);
    }

    $tpl->set_var( 'Month', "(".$Months[$Month-1]." <a href=\"?\">$Year</a>)"); 

    $tpl->set_var( 'SeeMonth', $Month ); 
    $tpl->set_var( 'SeeYear', $Year ); 

    $tpl->set_var( 'YearHeader',  ""); 
    $tpl->set_var( 'MonthHeader', ""); 
    $tpl->set_var( 'DayHeader',   "<td align=right class=\"gridcaption\"><font size=\"2\">Day</font></td>"); 

    $Year = Dec( $Year, 4 );
    $Month = Dec( $Month, 2 );

    for ( $i = $FromDay; $i <= $DaysCount; $i++ ) {
      $Day = Dec( $i, 2);

      $MyQuery = "(Date > \"$Year-$Month-$Day 00:00:00\") AND (Date < \"$Year-$Month-$Day 23:59:59\")$AddQuery";

      $r = @mysql( DBName, "SELECT count(distinct IP), ".
        "count(distinct Referer), count(distinct SiteUIN), ".
        "count(distinct ProductUIN) FROM $LogsTableName WHERE ($MyQuery)" );  
      if ( $r && $f = @mysql_fetch_array($r) ) {       
        $IPs          = $f[0];
        $Referer      = $f[1];
        $Sites        = $f[2];
        $Products     = $f[3];
      } else {
        $tpl->set_var( 'ErrorMessage', "Error: ".mysql_error() );
        $tpl->process( 'ErrorMessagePos', 'ErrorMessageBlock', 0, 0, 1 );
        $Serials      = "?";
        $Referer      = "?";
        $Sites        = "?";
        $Products     = "?";
      }

      $r = @mysql( DBName, "SELECT count(FileType) ".
        " FROM $LogsTableName WHERE ($MyQuery) AND (FileType = 0)" );  
      if ( $r && $f = @mysql_fetch_array($r) ) {       
        $PADCount     = $f[0];
      } else {
        $tpl->set_var( 'ErrorMessage', "Error: ".mysql_error() );
        $tpl->process( 'ErrorMessagePos', 'ErrorMessageBlock', 0, 0, 1 );
        $PADCount     = "?";
      }

      $r = @mysql( DBName, "SELECT count(FileType) ".
        " FROM $LogsTableName WHERE ($MyQuery) AND (FileType = 1)" );  
      if ( $r && $f = @mysql_fetch_array($r) ) {       
        $DistribCount = $f[0];
      } else {
        $tpl->set_var( 'ErrorMessage', "Error: ".mysql_error() );
        $tpl->process( 'ErrorMessagePos', 'ErrorMessageBlock', 0, 0, 1 );
        $DistribCount = "?";
      }

      $TotalCount   = $PADCount + $DistribCount;

      $DayCaption = 
        "<td align=right class=\"gridcaption\"><font size=\"2\">".
        "<a href=\"dp_logs.php?QueryField=date".
        "&Query=$Year-$Month-$Day\">$i</a></font></td>";

      $Period = array( 
        "Year"            => "",
        "Month"           => "",
        "Day"             => $DayCaption,
        "IPs"             => $IPs, 
        "Referer"         => $Referer,        
        "Sites"           => $Sites,        
        "Products"        => $Products,        
        "PADCount"        => $PADCount,        
        "DistribCount"    => $DistribCount,        
        "Total"           => $TotalCount,
      );

      $Periods[] = $Period;
    }

    $tpl->set_loop( 'Periods', $Periods );
    echo $tpl->process( 'out', 'main', 1 );
    exit;
  }

  // -------------------------------------------------------------------------
  $Year    = TRUE;
  $Month   = Dec( $StartMonth, 2 );
  $MyQuery = "(Date > \"$StartYear-01\") AND (Date < \"$StartYear-13\")$AddQuery";

  do {
    $r = @mysql( DBName, "SELECT count(distinct IP), ".
      "count(distinct Referer), count(distinct SiteUIN), ".
      "count(distinct ProductUIN) FROM $LogsTableName WHERE ($MyQuery)" );  
    if ( $r && $f = @mysql_fetch_array($r) ) {       
      $IPs          = $f[0];
      $Referer      = $f[1];
      $Sites        = $f[2];
      $Products     = $f[3];
    } else {
      $tpl->set_var( 'ErrorMessage', "Error: ".mysql_error() );
      $tpl->process( 'ErrorMessagePos', 'ErrorMessageBlock', 0, 0, 1 );
      $Serials      = "?";
      $Referer      = "?";
      $Sites        = "?";
      $Products     = "?";
    }

    $r = @mysql( DBName, "SELECT count(FileType) ".
      " FROM $LogsTableName WHERE ($MyQuery) AND (FileType = 0)" );  
    if ( $r && $f = @mysql_fetch_array($r) ) {       
      $PADCount     = $f[0];
    } else {
      $tpl->set_var( 'ErrorMessage', "Error: ".mysql_error() );
      $tpl->process( 'ErrorMessagePos', 'ErrorMessageBlock', 0, 0, 1 );
      $PADCount     = "?";
    }

    $r = @mysql( DBName, "SELECT count(FileType) ".
      " FROM $LogsTableName WHERE ($MyQuery) AND (FileType = 1)" );  
    if ( $r && $f = @mysql_fetch_array($r) ) {       
      $DistribCount = $f[0];
    } else {
      $tpl->set_var( 'ErrorMessage', "Error: ".mysql_error() );
      $tpl->process( 'ErrorMessagePos', 'ErrorMessageBlock', 0, 0, 1 );
      $DistribCount = "?";
    }

    $TotalCount   = $PADCount + $DistribCount;

    $MonthLink = "<a href=\"?Year=$StartYear&Month=$StartMonth$AddLink\">".
      $Months[$StartMonth-1]."</a>";

    if ( $Year === FALSE ) {
      $Periods[] = array( 
        "Year"            => "<td align=right class=\"gridcaption\"><font size=\"2\">&nbsp;</font></td>",
        "Month"           => "<td align=right class=\"gridcaption\"><font size=\"2\">$MonthLink</font></td>", 
        "Day"             => "",
        "IPs"             => $IPs, 
        "Referer"         => $Referer,        
        "Sites"           => $Sites,        
        "Products"        => $Products,        
        "PADCount"        => $PADCount,        
        "DistribCount"    => $DistribCount,        
        "Total"           => $TotalCount,
      );

      $StartMonth++;
      if ($StartMonth > 12) {
        $StartMonth = 1;
        $StartYear++;
        $Year = TRUE;
      }
    } else {
      $Periods[] = array( 
        "Year"            => "<td align=right class=\"gridcaption\"><font size=\"2\">$StartYear</font></td>",
        "Month"           => "<td align=right class=\"gridcaption\"><font size=\"2\">&nbsp;</font></td>", 
        "Day"             => "",
        "IPs"             => $IPs, 
        "Referer"         => $Referer,        
        "Sites"           => $Sites,        
        "Products"        => $Products,        
        "PADCount"        => $PADCount,        
        "DistribCount"    => $DistribCount,        
        "Total"           => $TotalCount,
      );

      $Year = FALSE;
    }

    if ( ($CurrentYear-$StartYear)*12-$StartMonth+$CurrentMonth < 0 ) { break; }

    $Month = Dec( $StartMonth, 2 );

    if ( $Year === TRUE ) {
      $MyQuery = "(Date > \"$StartYear-01\") AND (Date < \"$StartYear-13\")$AddQuery";
    } else {
      $MyQuery = "(Date > \"$StartYear-$Month-01\") AND (Date < \"$StartYear-$Month-32\")$AddQuery"; 
    }
  } while ( TRUE );

  $tpl->set_loop( 'Periods', $Periods );

  $tpl->set_var( 'SeeMonth', "" ); 
  $tpl->set_var( 'SeeYear',  "" ); 

  $tpl->set_var( 'YearHeader',  "<td align=right class=\"gridcaption\"><font size=\"2\">Year</font></td>"); 
  $tpl->set_var( 'MonthHeader', "<td align=right class=\"gridcaption\"><font size=\"2\">Month</font></td>"); 
  $tpl->set_var( 'DayHeader',   ""); 

  echo $tpl->process( 'out', 'main', 1 );
?>