<?php
  $AfterLogin = "dp_logs.php";

  require_once( $HomeDir."dp_conf.php" );
  require_once( $HomeDir."phemplate.class.php" );
  require_once( $HomeDir."pager.php" );

  function RefererLink( $Ref ) {
    $Ref2 = $Ref;

    if ( strlen($Ref) > 40 ) {
      $Ref = substr($Ref, 0, 40).'...';
    }

    return "<a href=\"$Ref2\">$Ref</a>";
  }

  $tpl = new phemplate();
  $tpl->set_root( $HomeDir );
  $tpl->set_file( 'main', 'dp_logs.tml', TRUE );
  $tpl->set_unknowns( 'remove_nonjs' );

  if ( !mysql_connect( DBHost, DBUser, DBPass ) ) {
    $tpl->set_var( 'ErrorMessage', "Error: Cannot connect to the database" );
    $tpl->process( 'ErrorMessagePos', 'ErrorMessageBlock', 0, 0, 1 );
    echo $tpl->process( 'out', 'main', 1 );
    exit;
  }

  $QueryField = GetGlobalVar( 'QueryField' );
  $Query      = GetGlobalVar( 'Query' );
  $Status     = GetGlobalVar( 'Status' );

  if ( strlen($QueryField) <= 0 ) { 
    $QueryField = 'date';
  }

  $Query = stripcslashes( $Query );
  $Query = str_replace( "'", '"', $Query );

  $Logs = array();

  $MyQuery = "SELECT * FROM $LogsTableName WHERE ";

  switch($QueryField) {
    case "ip":
      $tpl->set_var( 'IPChecked', "selected" ); 
      $MyQuery .= "IP LIKE '%$Query%'";
      break;
    case "referer":
      $tpl->set_var( 'RefererChecked', "selected" ); 
      $MyQuery .= "Referer LIKE '%$Query%'";
      break;
    case "site":
      $tpl->set_var( 'SiteChecked', "selected" ); 

      $MO = LoadMultiOptions( $ConfigPath );
      $Key = strtoupper( GetKeyByValue( $MO['Sites'], $Query ) );
      if ( strlen($Key) > 0 ) {
        $MyQuery .= "SiteUIN IN ($Key)";
      } else $MyQuery .= "SiteUIN LIKE '%$Query%'"; 

      break;
    case "product":
      $tpl->set_var( 'ProductChecked', "selected" ); 
     
      $MO = LoadMultiOptions( $ConfigPath );
      $Key = strtoupper( GetKeyByValue( $MO['Products'], $Query ) );
      if ( strlen($Key) > 0 ) {
        $MyQuery .= "ProductUIN IN ($Key)";
      } else $MyQuery .= "ProductUIN LIKE '%$Query%'"; 

      break;
    case 'date':
      $tpl->set_var( 'DateChecked', "selected" ); 

      if ($Query != '*') {
        if ( $Query == '' ) {
          $Query = date( 'Y-m-d', time() );
        }

        $Date = date("Y-m-d", strtotime($Query));
        $MyQuery .= "Date LIKE '%$Date%'";
      } else {
        $MyQuery .= "Date<>''";
      }

      break;
  }

  switch( $Status ) {
    case '1': $MyQuery .= " AND FileType=1"; break;
    case '2': $MyQuery .= " AND FileType=0"; break;
  }

  
  $r = mysql( DBName, $MyQuery );
  if ( !$r ) {
    $tpl->set_var( 'ErrorMessage', "Error: ".mysql_error() );
    $tpl->process( 'ErrorMessagePos', 'ErrorMessageBlock', 0, 0, 1 );
    echo $tpl->process( 'out', 'main', 1 );
    exit;
  }

  $Pager = new Pager( $r, $MaxResultsPerPage );

  $NavLink = $Pager->getPageNav( "&Status=$Status&QueryField=$QueryField&Query=$Query" );
  $NavResults = $Pager->getResultsInfo();

  $tpl->set_var( 'NavLink', $NavLink );
  $tpl->set_var( 'NavResults', $NavResults );

  $MO = LoadMultiOptions( $ConfigPath );
  $SitesList = $MO['Sites'];
  $ProductsList = $MO['Products'];

  $UIN = 0;
  while( $f = $Pager->fetchArray() ) {
    $Log = array( 
      "IP"                 => $f[IP],
      "SiteUIN"            => $f[SiteUIN],
      "ProductUIN"         => $f[ProductUIN],
      "Language"           => $f[Language],
      "Referer"            => RefererLink($f[Referer]), 
      "Date"               => date("d F H:i", strtotime($f[Date])),
    );

    $SiteName = $SitesList[strtoupper($f[SiteUIN])];
    $ProductName = $ProductsList[strtoupper($f[ProductUIN])];

    if ( strlen($SiteName) == 0 ) {
      $Log['SiteName'] = $f[SiteUIN];
    } else $Log['SiteName'] = $SiteName;

    if ( strlen($ProductName) == 0 ) {
      $Log['ProductName'] = $f[ProductUIN];
    } else $Log['ProductName'] = $ProductName;

    switch ( $f[FileType] ) {
      case PAD:     $Log[FileType] = "PAD";          break;
      case Distrib: $Log[FileType] = "Distributive"; break;
      default:      $Log[FileType] = "?";            break;
    }

    $Logs[] = $Log;

    $UIN++;
  }

  $tpl->set_loop( 'Log', $Logs );

  $tpl->set_var( 'Query', $Query ); 
  $tpl->set_var( 'QueryField', $QueryField );
  $tpl->set_var( 'Status', $Status );

  echo $tpl->process( 'out', 'main', 1 );
?>