<?php
  Error_Reporting(0);
 
  if ( file_exists( "dp_conf.php.inc" ) ) {
    include( "dp_conf.php.inc" ); 
  } else die( '<center>Unable to find dp_conf.php.inc</center>' );   

  $HomeDir = trim( $HomeDir );
  $DataDir = trim( $DataDir );

  $i = strlen( $HomeDir );
  if ( $HomeDir[$i-1] != '/' ) $HomeDir .= '/'; 
  $i = strlen( $DataDir );
  if ( $DataDir[$i-1] != '/' ) $DataDir .= '/'; 

  $ConfigPath = $HomeDir."dp_conf.dat";
  $LogsTableName = $TablesPrefix."report";
  $StatTableName = $TablesPrefix."sitestat";

  define( "PAD"        , 0 );
  define( "Distrib"    , 1 );
  define( "DefaultPAD" , 2 );

  function GetGlobalVar( $VarName ) {
    global $HTTP_POST_VARS, $HTTP_GET_VARS;

    if ( strlen($HTTP_POST_VARS[$VarName]) > 0 ) {
      return $HTTP_POST_VARS[$VarName];
    }

    if ( strlen($HTTP_GET_VARS[$VarName]) > 0 ) {
      return $HTTP_GET_VARS[$VarName];
    }

    return '';
  }

  $Action = GetGlobalVar( 'Action' );

  if (strlen($AfterLogin) > 0) {
    session_start();
    session_register( 'Login', 'Password' );

    if( $Action == 'Logout' ) {
      SetCookie( 'Login' );
      SetCookie( 'Password' );

      $HTTP_SESSION_VARS['Login'] = "";
      $HTTP_SESSION_VARS['Password'] = "";

      $HTTP_COOKIE_VARS['Login'] = "";
      $HTTP_COOKIE_VARS['Password'] = "";

      if( @Header( "Location: http://".$HTTP_HOST.$PHP_SELF ) ) exit;
    }

    if( ($Action == 'Login') || ($Action == 'UploadProductDatFile') ) {
      if( strlen($HTTP_GET_VARS['Login']) ) {
        $HTTP_SESSION_VARS['Login'] = $HTTP_GET_VARS['Login'];
      }

      if( strlen($HTTP_GET_VARS['Password']) ) {
        $HTTP_SESSION_VARS['Password'] = md5($HTTP_GET_VARS['Password']);
      }

      if( strlen($HTTP_POST_VARS['Login']) ) {
        $HTTP_SESSION_VARS['Login'] = $HTTP_POST_VARS['Login'];
      }

      if( strlen($HTTP_POST_VARS['Password']) ) {
        $HTTP_SESSION_VARS['Password'] = md5($HTTP_POST_VARS['Password']);
      }

      if( $HTTP_POST_VARS['SavePassword'] ) {
        SetCookie( 'Login', $HTTP_SESSION_VARS['Login'], time() + 2678400 );
        SetCookie( 'Password', $HTTP_SESSION_VARS['Password'], time() + 2678400 );
      } else {
        SetCookie( 'Login' );
        SetCookie( 'Password' );
      }
    }

    @Header( "Content-Type: text/html; charset=windows-1251" );
    @Header( "Cache-Control: no-cache, must-revalidate" );
    @Header( "Pragma: no-cache" );

    if( ($HTTP_SESSION_VARS['Login'] != Login) ||
         $HTTP_SESSION_VARS['Password'] != md5(Password) ) {
      if( $HTTP_COOKIE_VARS['Login'] ) $HTTP_SESSION_VARS['Login'] = $HTTP_COOKIE_VARS['Login'];
      if( $HTTP_COOKIE_VARS['Password'] ) $HTTP_SESSION_VARS['Password'] = $HTTP_COOKIE_VARS['Password'];

      if ( $Action == 'UploadProductDatFile' ) {
        die( "Message=Authorization failed" );
      }

      require_once( "phemplate.class.php" );

      $tpl = new phemplate();
      $tpl->set_root( $HomeDir );
      $tpl->set_file( 'main', 'dp_login.tml' );

      $tpl->set_var( 'AfterLogin', $AfterLogin);
      $tpl->set_var( 'Login', (strlen($HTTP_SESSION_VARS['Login']) ? $HTTP_SESSION_VARS['Login'] : '' ) );
      $tpl->set_var( 'SavePassword', ($HTTP_COOKIE_VARS['Login'] ? ' checked' : '' ) );

      echo $tpl->process( 'out', 'main', 1 );

      exit;
    }
  }

  function LoadMultiOptions( $FileName ) {
    $f = fopen ( $FileName, "r" );
    $MO = explode( "\r\n", fread( $f, filesize($FileName) ) );
    fclose ( $f );

    $Result = array();   
    
    reset( $MO );
    foreach( $MO as $Item ) {
      $tItem = trim( $Item );      
      $Len = strlen( $tItem );    

      if ( ( $Len > 1) && ( $tItem[0] == '[' ) && ( $tItem[$Len-1] == ']' ) ) {
        if ( isset( $OL ) ) $Result[$OLName] = $OL;

        unset( $OL );

        $OLName = trim( substr( $tItem, 1, $Len-2  ) );
        $OL = array();
      } else {
        if ( isset( $OL ) ) {
          $Pos = strpos( $Item, '=' );
          if ( $Pos > 0 ) {
            $Key = substr( $Item, 0, $Pos );
            $Value = substr( $Item, $Pos+1 );
            $OL[$Key] = urldecode($Value);
          } else {
            $OL[] = $Item;
          }
        }
      }
    }
    if ( isset( $OL ) ) $Result[$OLName] = $OL;

    return $Result;
  }

  function SaveMultiOptions( $FileName, &$MO ) {
    $String = '';

    reset( $MO );
    foreach( $MO as $OLName => $OL ) {
      $String .= "[$OLName]\r\n";

      reset( $OL );
      foreach( $OL as $Key => $Value ) {
        $Value = urlencode( $Value );

        if ( ! is_integer($Key) ) {
          $String .= "$Key=$Value\r\n";
        } else {
          $String .= "$Value\r\n";
        }
      }
    }

    $f = fopen( $FileName, "w" );
    fwrite( $f, $String );
    fclose ( $f );
  }

  function GetValueByIndex( $OL, $Index, $Prefix, &$Result ) {
    if ( ! is_array( $OL ) ) return "";

    if ( strlen($Prefix) > 0 ) {
      $i = 0;
      $j = 0;
      reset( $OL );
      foreach( $OL as $Key => $Value ) {
        if ( strpos($Key, $Prefix) === 0 ) $j++;

        $i++;
      }

      if ( ($i == 0) || ( $j == 0 ) ) {
        $Result = "";
        return FALSE;
      }

      $Index = round($j * $Index / $i);

      $i = 0;
      $j = 0;
      reset( $OL );
      foreach( $OL as $Key => $Value ) {
        if ( strpos($Key, $Prefix) === 0 ) {
          if ($j == $Index) {
            $Result = $Value;
            return TRUE;
          }
          $j++;
        }

        $i++;
      }

      $Result = "";
      return FALSE;
    }

    $i = 0;
    $j = 0;
    reset( $OL );
    foreach( $OL as $Key => $Value ) {
      if ($i == $Index) {
        $Result = $Value;
        return TRUE;
      }

      $i++;
    }

    $Result = "";
    return FALSE;
  }

  function UpdateSection( &$MO, $SectionName, $Text ) {
    if ( ! is_array( $MO ) ) return FALSE;  

    if ( is_array($MO[$SectionName]) ) unset( $MO[$SectionName] );

    $OL = array();
    
    $SL = explode( "\r\n", $Text );

    foreach( $SL as $Item ) {
      $Pos = strpos( $Item, '=' );
      if ( $Pos > 0 ) {
        $Key = substr( $Item, 0, $Pos );
        $Value = substr( $Item, $Pos+1 );
        $OL[$Key] = urldecode($Value);
      } else {
        $OL[] = $Item;
      }
    }

    $MO[$SectionName] = $OL;

    return TRUE;
  }

  function GetKeyByValue( &$OL, $Value, $ExactSearch=FALSE ) {
    $Result = "";

    if ( ! is_array( $OL ) ) return $Result;

    reset( $OL );

    if ( $ExactSearch ) {
      foreach( $OL as $cKey => $cValue ) {
        if ($cValue == $Value) return $cKey;
      }
    } else {
      $Value = strtoupper( $Value );

      foreach( $OL as $cKey => $cValue ) {
        $cValue = strtoupper( $cValue );

        if ( strpos( $cValue, $Value ) !== FALSE ) {
          if ( strlen($Result) == 0  ) {
            $Result = "'$Prefix$cKey'";
          } else $Result .= ",'$Prefix$cKey'";
        }
      }
    }

    return $Result;
  }

  function DownloadFile( $Host, $File ) {
    $Content = "";

    $IP = gethostbyname( $Host );

    $fp = fsockopen( $IP, 80 );

    if ( $fp ) {
      $Command = 
        "GET $File HTTP/1.0\r\n".
        "Accept: */*\r\n".
        "User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)\r\n".
        "Host: $IP\r\n".
        "Proxy-Connection: close\r\n".
        "Pragma: no-cache\r\n".
        "Connection: Keep-Alive\r\n\r\n";

      fputs( $fp, $Command );

      while ( !feof($fp) ) {
        $Content .= fread( $fp, 512 );
      }

      fclose($fp);

      $Content = substr( $Content, strpos($Content, "\r\n\r\n") + 4 );
    }

    return $Content;
  }

  function GetDir( $FileName ) {
    $FileName = str_replace( '\\', '/', $FileName );

    $j = -1;
    for ( $i = strlen($FileName); $i >= 0; $i-- ) {
      if ( $FileName[$i] == '/' ) {
        $j = $i;
        break;
      }
    }

    if ( $j >= 0 ) {
      return substr($FileName, 0, $j);
    } else return "";
  }

?>